﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PlayerMovementScript : MonoBehaviour
{
    public CharacterController controller;


    public float speed = 12f;
    public float gravity = -9.81f;
    public float jumpHeight = 4f;

    public Transform groundCheck;
    public float groundDistance = 0.4f;
    public LayerMask groundMask;
    public LayerMask Everything;

    Vector3 velocity;
    public bool isGrounded;
    public Vector3 centerPosition;
    public Vector3 halfExtents;


    // Start is called before the first frame update
    void Start()
    {

    }

    void OnDrawGizmosSelected()
    {
        Gizmos.color = Color.yellow;
        Gizmos.DrawCube(groundCheck.position, halfExtents);
    }

    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.LeftShift))
        {
            speed = speed + 5;
        }
        if (Input.GetKeyUp(KeyCode.LeftShift))
        {
            speed = speed - 5;
        }
        centerPosition = groundCheck.position;
        isGrounded = Physics.CheckBox(groundCheck.position, halfExtents, Quaternion.Euler(0,0,0), groundMask);
        //isGrounded = Physics.CheckSphere(groundCheck.position, groundDistance, groundMask);

        if (isGrounded && velocity.y < 0)
        {
            velocity.y = 0f;
        }

        float x = Input.GetAxis("Horizontal");
        float z = Input.GetAxis("Vertical");

        Vector3 move = transform.right * x + transform.forward * z;

        controller.Move(move * speed * Time.deltaTime);

        velocity.y += gravity * Time.deltaTime;

        controller.Move(velocity * Time.deltaTime);

        if (Input.GetKeyDown(KeyCode.W) || Input.GetKeyDown(KeyCode.S))
        {
            GameObject.Find("TomatoSoup").GetComponent<Animator>().SetBool("Walking", true);
        }
        if(Input.GetKeyUp(KeyCode.W) || Input.GetKeyUp(KeyCode.S))
        {
            GameObject.Find("TomatoSoup").GetComponent<Animator>().SetBool("Walking", false);
        }
        if(Input.GetKeyDown(KeyCode.Space) && gameObject.GetComponent<MouseLook>().isPaused == false && isGrounded)
        {
            velocity.y = Mathf.Sqrt(jumpHeight * -1f * gravity);
            Debug.Log($"Jumped");
        }
        
    }
}
